var loc = window.location, new_uri;

var ws_url = loc.protocol === "https:" ? "wss://" : "ws://";
ws_url += loc.host + "/ws";
var socket = new WebSocket(ws_url);

socket.addEventListener('open', (event) => {
	// search for all "component-" class elements and subscribe to
	// updates
	var els = document.getElementsByTagName("*");
	var components = {};
	for (var i = 0; i < els.length; i++) {
		connectEventHandlers(els.item(i));
	}
});

socket.addEventListener('close', (event) => {
    console.log("CLOSED");
    // TODO: reconnect
});

socket.addEventListener('message', (event) => {
	var msg = JSON.parse(event.data);
	// update all matching elements for the updated component
	var els = document.getElementsByClassName("component-"+msg.component);
	for (var i = 0; i < els.length; i++){
		els.item(i).innerHTML = msg.content;
		var children = els.item(i).getElementsByTagName("*");
		for (var j = 0; j < children.length; j++)
			connectEventHandlers(children.item(j));
	}
	return false;
});

function connectEventHandlers(element)
{
	var classes = element.classList;
	for (var j = 0; j < classes.length; j++) {
		let cls = classes.item(j);
		if (cls.startsWith("component-")) {
			socket.send(JSON.stringify({
				command: "subscribe",
				payload: cls.substr(10)
			}));
		}
		if (cls.startsWith("event-")) {
			element.addEventListener("click", (event) => {
				socket.send(JSON.stringify({
					command: "event",
					payload: cls.substr(6)
				}));
			})
		}
	}
} 
